<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Position extends Model 
{

    protected $table = 'positions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function job()
    {
        return $this->belongsTo('App\Models\HR\Job', 'job_id');
    }

    public function appointments()
    {
        return $this->hasMany('App\Models\HR\Appointment', 'position_id');
    }

    public function location()
    {
        return $this->belongsTo('App\Models\Company\Location', 'location_id');
    }

    public function team()
    {
        return $this->belongsTo('App\Models\HR\Team', 'team_id');
    }

}